/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.util.io;

import com.t2pellet.strawgolem.platform.Services;
import com.t2pellet.strawgolem.util.io.ConfigHelper;
import com.t2pellet.strawgolem.util.io.IniFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class Config {
    private static final String CONFIG_DIR = Services.PLATFORM.getGameDir() + "/config/";
    private final File file;

    protected Config(String modid) {
        this.file = new File(CONFIG_DIR + modid + ".ini");
    }

    void save() throws IOException, IllegalAccessException {
        IniFile iniFile = IniFile.newInstance();
        for (Class<?> aClass : this.getClass().getDeclaredClasses()) {
            if (!aClass.isAnnotationPresent(ConfigHelper.Section.class)) continue;
            ConfigHelper.Section section = aClass.getAnnotation(ConfigHelper.Section.class);
            IniFile.Section s = iniFile.addSection(section.value());
            for (Field declaredField : aClass.getDeclaredFields()) {
                declaredField.setAccessible(true);
                s.add(declaredField.getName(), declaredField.get(null));
                if (!declaredField.isAnnotationPresent(ConfigHelper.Section.Comment.class)) continue;
                ConfigHelper.Section.Comment comment = declaredField.getAnnotation(ConfigHelper.Section.Comment.class);
                s.comment(declaredField.getName(), comment.value());
            }
        }
        iniFile.store(this.file);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void load() throws IOException, IllegalAccessException {
        Class<?>[] declaredClasses;
        if (this.file.createNewFile()) {
            this.save();
        }
        IniFile iniFile = IniFile.newInstance();
        iniFile.load(this.file);
        for (Class<?> declaredClass : declaredClasses = this.getClass().getDeclaredClasses()) {
            ConfigHelper.Section section;
            IniFile.Section s;
            if (!declaredClass.isAnnotationPresent(ConfigHelper.Section.class) || (s = iniFile.getSection((section = declaredClass.getAnnotation(ConfigHelper.Section.class)).value())) == null) continue;
            for (Field declaredField : declaredClass.getDeclaredFields()) {
                void var13_13;
                if (List.class.isAssignableFrom(declaredField.getType())) {
                    Type listType = declaredField.getGenericType();
                    if (!(listType instanceof ParameterizedType)) throw new IllegalArgumentException("Invalid list type: " + listType);
                    Class type = (Class)((ParameterizedType)listType).getActualTypeArguments()[0];
                    List list = s.getAll(declaredField.getName(), type);
                } else {
                    Object obj = s.get(declaredField.getName(), declaredField.getType());
                }
                if (var13_13 == null) continue;
                Config.setField(declaredField, var13_13);
            }
        }
        this.save();
    }

    private static void setField(Field field, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(null, value);
    }
}

